<?php

namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * CompanyBankServiceOption
 *
 * @ORM\Table(name="company_bank_service_options")
 * @ORM\Entity(repositoryClass="VM\ApiBundle\Repository\CompanyBankServiceOptionsRepository")
 *
 * @ExclusionPolicy("all")
 * @ORM\HasLifecycleCallbacks
 */
class CompanyBankServiceOption
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"bankServiceDetails","companyDetails", "companyBankServiceDetails"})
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="company_id", type="integer")
     */
    private $companyId;

    /**
     * @var integer
     *
     * @ORM\Column(name="option_id", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"companyBankServiceDetails"})
     */
    private $optionId;

    /**
     * @var integer
     *
     * @ORM\Column(name="round_id", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"companyBankServiceDetails"})
     */
    private $roundId;

    /**
     * @var float
     *
     * @ORM\Column(name="value", type="decimal", precision=13, scale=2)
     *
     * @Expose
     * @AnnotationGroups({"bankServiceDetails","companyDetails", "companyBankServiceDetails"})
     */
    private $value;

    /**
     * @var string
     *
     * @ORM\Column(name="description", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"bankServiceDetails","companyDetails", "companyBankServiceDetails"})
     */
    private $description = '';

    /**
     * @var float
     *
     * @ORM\Column(name="init_value", type="decimal", precision=13, scale=2)
     *
     * @Expose
     * @AnnotationGroups({"bankServiceDetails","companyDetails", "companyBankServiceDetails"})
     */
    private $initValue = 0;

    /**
     * @var version
     *
     * @ORM\Version @ORM\Column(name="version", type="integer")
     */
    private $version;

    /**
     * @ORM\ManyToOne(targetEntity="Company",inversedBy="bankServiceOptions")
     * @ORM\JoinColumn(name="company_id", referencedColumnName="id")
     */
    private $company;

    /**
     * @ORM\ManyToOne(targetEntity="Round",inversedBy="companyBankServiceOptions")
     * @ORM\JoinColumn(name="round_id", referencedColumnName="id")
     */
    private $round;

    /**
     * @ORM\ManyToOne(targetEntity="BankServiceOptions",inversedBy="companyBankServiceOptions")
     * @ORM\JoinColumn(name="option_id", referencedColumnName="id")
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails", "bankServiceDetails"})
     */
    private $option;

    /**
     * @ORM\OneToMany(targetEntity="CompanyAllegroCategoryItem", mappedBy="loan")
     */
    protected $companyItems;

    /**
     * @ORM\OneToMany(targetEntity="AccountChange", mappedBy="companyBankServiceOption", cascade={"persist", "remove"})
     * @ORM\OrderBy({"createAt"="DESC"})
     */
    protected $accountChanges;


    /**
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        $this->initValue = $this->value;
    }



    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set companyId
     *
     * @param integer $companyId
     * @return CompanyBankServiceOption
     */
    public function setCompanyId($companyId)
    {
        $this->companyId = $companyId;
    
        return $this;
    }

    /**
     * Get companyId
     *
     * @return integer 
     */
    public function getCompanyId()
    {
        return $this->companyId;
    }

    /**
     * Set optionId
     *
     * @param integer $optionId
     * @return CompanyBankServiceOption
     */
    public function setOptionId($optionId)
    {
        $this->optionId = $optionId;
    
        return $this;
    }

    /**
     * Get optionId
     *
     * @return integer 
     */
    public function getOptionId()
    {
        return $this->optionId;
    }

    /**
     * Set value
     *
     * @param float $value
     * @return CompanyBankServiceOption
     */
    public function setValue($value)
    {
        $this->value = $value;
    
        return $this;
    }

    /**
     * Get value
     *
     * @return float 
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * Set company
     *
     * @param \VM\ApiBundle\Entity\Company $company
     * @return CompanyBankServiceOption
     */
    public function setCompany(\VM\ApiBundle\Entity\Company $company = null)
    {
        $this->company = $company;
    
        return $this;
    }

    /**
     * Get company
     *
     * @return \VM\ApiBundle\Entity\Company 
     */
    public function getCompany()
    {
        return $this->company;
    }

    /**
     * Set option
     *
     * @param \VM\ApiBundle\Entity\BankServiceOptions $option
     * @return CompanyBankServiceOption
     */
    public function setOption(\VM\ApiBundle\Entity\BankServiceOptions $option = null)
    {
        $this->option = $option;
    
        return $this;
    }

    /**
     * Get option
     *
     * @return \VM\ApiBundle\Entity\BankServiceOptions
     */
    public function getOption()
    {
        return $this->option;
    }

    /**
     * Set roundId
     *
     * @param integer $roundId
     * @return CompanyBankServiceOption
     */
    public function setRoundId($roundId)
    {
        $this->roundId = $roundId;
    
        return $this;
    }

    /**
     * Get roundId
     *
     * @return integer 
     */
    public function getRoundId()
    {
        return $this->roundId;
    }

    /**
     * Set round
     *
     * @param \VM\ApiBundle\Entity\Round $round
     * @return CompanyBankServiceOption
     */
    public function setRound(\VM\ApiBundle\Entity\Round $round = null)
    {
        $this->round = $round;
    
        return $this;
    }

    /**
     * Get round
     *
     * @return \VM\ApiBundle\Entity\Round 
     */
    public function getRound()
    {
        return $this->round;
    }

    /**
     * Set version
     *
     * @param integer $version
     * @return CompanyBankServiceOption
     */
    public function setVersion($version)
    {
        $this->version = $version;
    
        return $this;
    }

    /**
     * Get version
     *
     * @return integer 
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->companyItems = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Add companyItems
     *
     * @param \VM\ApiBundle\Entity\CompanyAllegroCategoryItem $companyItems
     * @return CompanyBankServiceOption
     */
    public function addCompanyItem(\VM\ApiBundle\Entity\CompanyAllegroCategoryItem $companyItems)
    {
        $this->companyItems[] = $companyItems;
    
        return $this;
    }

    /**
     * Remove companyItems
     *
     * @param \VM\ApiBundle\Entity\CompanyAllegroCategoryItem $companyItems
     */
    public function removeCompanyItem(\VM\ApiBundle\Entity\CompanyAllegroCategoryItem $companyItems)
    {
        $this->companyItems->removeElement($companyItems);
    }

    /**
     * Get companyItems
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCompanyItems()
    {
        return $this->companyItems;
    }

    /**
     * Set description
     *
     * @param string $description
     * @return CompanyBankServiceOption
     */
    public function setDescription($description)
    {
        $this->description = $description;
    
        return $this;
    }

    /**
     * Get description
     *
     * @return string 
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Add accountChanges
     *
     * @param \VM\ApiBundle\Entity\AccountChange $accountChanges
     * @return CompanyBankServiceOption
     */
    public function addAccountChange(\VM\ApiBundle\Entity\AccountChange $accountChanges)
    {
        $this->accountChanges[] = $accountChanges;
    
        return $this;
    }

    /**
     * Remove accountChanges
     *
     * @param \VM\ApiBundle\Entity\AccountChange $accountChanges
     */
    public function removeAccountChange(\VM\ApiBundle\Entity\AccountChange $accountChanges)
    {
        $this->accountChanges->removeElement($accountChanges);
    }

    /**
     * Get accountChanges
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getAccountChanges()
    {
        return $this->accountChanges;
    }

    /**
     * Set initValue
     *
     * @param float $initValue
     * @return CompanyBankServiceOption
     */
    public function setInitValue($initValue)
    {
        $this->initValue = $initValue;
    
        return $this;
    }

    /**
     * Get initValue
     *
     * @return float 
     */
    public function getInitValue()
    {
        return $this->initValue;
    }
}